#ifndef _GST_ENUMS_H_
#define _GST_ENUMS_H_

#include <buildspec.h>
#include <string>

namespace GST
{
//-------------------------------------------
// Here comes the global enums
//-------------------------------------------
enum Protocol
{
	PGDIRECT = 10,
	PGSSL = 11,
	OCCIDIRECT = 20,
	MSSQLDIRECT = 30,
	GRPC = 40
};

/**
 * Datatype for Property
 */
enum DataType
{
	TypeCustom,
	TypeSerial,
	TypeBool,
	TypeInt,
	TypeLong,
	TypeFloat,
	TypeVecFloat,
	TypeDouble,
	TypeText,
	TypeColorRgba,
	TypeTimestamp,
	TypeBinary,
	TypeUnkown
};
typedef DataType PropertyDataType;

enum LockType
{
	Lock_None,
	Lock_Object,
	Lock_Part
};

enum ImageType
{
	ImageType_SVG,
	ImageType_PDF,
	ImageType_PNG
};
std::string GST_API_EXPORT ImageType2String(const ImageType &imagetype);
ImageType GST_API_EXPORT String2ImageType(const std::string &imagetypeStr);

namespace Utils
{

enum LogLevel
{
	LOG_QUIET = 0, ///< writes no logs
	LOG_ERROR = 1, ///< writes logs of type error
	LOG_WARNING = 2, ///< writes logs of type warning
	LOG_STATUS = 4, ///< writes logs of type status
	LOG_DEBUG = 8, ///< writes logs of type debug messages
	LOG_SQL = 16 ///< writes logs of type sql statements
};

#define LOG_ALL \
	(LogLevel)(LOG_ERROR | LOG_WARNING | LOG_STATUS | LOG_DEBUG | LOG_SQL)
#define LOG_PUBLIC (LogLevel)(LOG_ERROR | LOG_WARNING | LOG_STATUS)
#define LOG_ESSENTIALS (LogLevel)(LOG_ERROR | LOG_WARNING)

} // namespace Utils

namespace Geometry
{
enum GeometryTypes
{
	unkown = 0,
	Multipoint3 = 1,
	Multiline3 = 2,
	Tin3 = 3,
	Multipolygon3 = 4,
	Geomcollection3 = 5,
	RegularGrid3 = 6,
	StructuredGrid3 = 7,
	Profile = 8,
	ElevationGrid = 9,
	Segy2D = 10,
	Segy3D = 11,
};
// always only add at the end, or make sure you adjust
// `GSTWeb::requestFormatFromNumber` and the web frontend
enum RequestFormats
{
	SFS,
	SFSP,
	GML,
	X3D,
	OBJ,
	PL2,
	GCD,
	BIN,
	SURPAC,
	DAE,
	KMZ,
	VTK,
	ISATIS,
	CSV,
	X3DOMPOP,
	I3S_SLPK,
	USDZ,
	IFC,
	GPKG,
	SHP,
	SHPCOLLECTION,
	GSTWEBBIN,
	GSTWEBPOP,
	SEGY,
	SHPPROFILE,
	GLTF,
	KML,
	SHPPOINTCLOUD,
	RESQML,
	TILES3D,
	GEOTIFF,
	NETCDF,
	FDSN,
	SAXQUAKE,
	GPKGPOINTCLOUD,
	STL,
	DXF,
	GEOH5,
};
typedef DataType PropertyTypes;

enum PropertyAlignments
{
	VERTEX_ALIGNED,
	CENTROID_ALIGNED,
	UNKNOWN_ALIGNED,
};

std::string GST_API_EXPORT GeometryTypeToString(const GeometryTypes &gt);
GeometryTypes GST_API_EXPORT
StringToGeometryType(const std::string &geometryTypeString);
std::string GST_API_EXPORT
PropertyAlignmentToString(const PropertyAlignments &pa);
PropertyAlignments GST_API_EXPORT
StringToPropertyAlignment(const std::string &propertyAlignmentStr);
GeometryTypes GST_API_EXPORT GeometryTypeFromString(std::string s);

} // namespace Geometry
} // namespace GST

#endif //_GST_ENUMS_H_
